﻿#Update $RegistryPath Value for your Environment. 
$RegistryPath = "HKLM:\SOFTWARE\WaaS"
$LogFile = "C:\ProgramData\WaaS\WaaS_OSUninstall.log" #Default if one isn't specified in Task Sequence
$OSUninstallBuild = Get-ItemPropertyValue -Path "$RegistryPath" -Name OSUninstall
$RegistryPathFull = "$RegistryPath\$OSUninstallBuild"
$WaaSStage = Get-ItemPropertyValue "$RegistryPathFull" 'WaaS_Stage' -ErrorAction SilentlyContinue
function Test-RegistryValue
{
    <# 
    .SYNOPSIS 
    Tests if a registry value exists. 
     
    .DESCRIPTION 
    The usual ways for checking if a registry value exists don't handle when a value simply has an empty or null value. This function actually checks if a key has a value with a given name. 
     
    .EXAMPLE 
    Test-RegistryKeyValue -Path 'hklm:\Software\Carbon\Test' -Name 'Title' 
     
    Returns `True` if `hklm:\Software\Carbon\Test` contains a value named 'Title'. `False` otherwise. 
    #>
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true)]
        [string]
        # The path to the registry key where the value should be set. Will be created if it doesn't exist.
        $Path,
        
        [Parameter(Mandatory=$true)]
        [string]
        # The name of the value being set.
        $Name
    )
    
    Set-StrictMode -Version 'Latest'

    #Use-CallerPreference -Cmdlet $PSCmdlet -Session $ExecutionContext.SessionState

    if( -not (Test-Path -Path $Path -PathType Container) )
    {
        return $false
    }
    
    $properties = Get-ItemProperty -Path $Path 
    if( -not $properties )
    {
        return $false
    }
    
    $member = Get-Member -InputObject $properties -Name $Name
    if( $member )
    {
        return $true
    }
    else
    {
        return $false
    }
}


if (((Test-RegistryValue -Path "$RegistryPath" -Name "CustomLogPreFix") -eq $true) -and ((Test-RegistryValue -Path "$RegistryPath" -Name "CustomLogPath") -eq $true))
    {
    $CustomLogPath = Get-ItemPropertyValue -Path $RegistryPath -Name "CustomLogPath"
    $CustomLogPreFix = Get-ItemPropertyValue -Path $RegistryPath -Name "CustomLogPreFix"
    $LogFile = "$CustomLogPath\$($CustomLogPreFix)_OSUninstall.log"
    }
if ((Test-RegistryValue -Path "$RegistryPath" -Name "LegalText_DefaultIsEnabled") -eq $true)
    {$LegalText_DefaultIsEnabled = Get-ItemPropertyValue -Path $RegistryPath -Name "LegalText_DefaultIsEnabled"}

if ((Test-RegistryValue -Path "$RegistryPath" -Name "LegalText_EnableMods") -eq $true)
    {
    $LegalText_EnableMods = Get-ItemPropertyValue -Path $RegistryPath -Name "LegalText_EnableMods"
    if ($LegalText_EnableMods -eq $true)
        {
        if ($LegalText_DefaultIsEnabled -eq $True)
            {
            $legalnoticecaption = Get-ItemPropertyValue -Path $RegistryPath -Name "LegalText_DefaultCaption"
            $legalnoticetext = Get-ItemPropertyValue -Path $RegistryPath -Name "LegalText_DefaultText"
            }
        }
    }
#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component = $env:computername,
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

if ($WaaSStage -eq "OSUninstallStarted" -or $WaaSStage -eq "OSUninstallComplete") #OSUninstall is set using a OSUninstall TS post Upgrade, to allow being reverted, so this will never run if this key isn't set by the OSUninstall TS
    {
    CMTraceLog -Message  "---Starting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    if ($LegalText_DefaultIsEnabled -eq $True)
        {
        Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $legalnoticecaption
        Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $legalnoticetext
        $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
        CMTraceLog -Message  "Updated Values: legalnoticecaption & legalnoticetext" -Type 1 -LogFile $LogFile -Component LegalText-Default
        CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
        }
    else
        {
        Remove-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption
        Remove-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext
        CMTraceLog -Message  "LegalCaption Was Deleted" -Type 1 -LogFile $LogFile -Component LegalText-Default
        }
    Unregister-ScheduledTask -TaskName SetLegalNoticeText-OSUninstallDefault -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task SetLegalNoticeText-OSUninstallDefault" -Type 1 -LogFile $LogFile -Component LegalText-Default
    CMTraceLog -Message  "---Exiting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    }